#version 330
#extension GL_EXT_gpu_shader4 : enable
//AntiPod - Gay CrushMod01.fsh  by  Flopine
//https://www.shadertoy.com/view/7llSz2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings and FabriceNeyret for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty


#define PI acos(-1.)
#define TAU 6.283185
#define hr vec2(1.,sqrt(3.))

#define BPM (125./60.)
#define dt(sp,off) fract((iTime+off)*sp)
#define sw(sp,off,num) (floor(sin(dt(sp,off)*PI)*num))

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))
#define palette(t,c,d,a) (vec3(a)+vec3(0.5)*cos(TAU*(c*t+d)))
#define AAstep(thre, val) smoothstep(-.7,.7,(val-thre)/min(0.07,fwidth(val-thre)))

void moda (inout vec2 p, float rep)
{
    float per = TAU/rep;
    float a = mod(atan(p.y,p.x),per)-per*.5;
    p = vec2(cos(a),sin(a))*length(p);
}

void mo (inout vec2 p, vec2 d)
{p = abs(p)-d;if(p.y>p.x)p=p.yx;}

vec3 frame (vec2 uv)
{
    vec2 ga=mod(uv,hr)-hr*.5,
    gb=mod(uv-hr*.5,hr)-hr*.5,
    guv=(dot(ga,ga)<dot(gb,gb))?ga:gb,
    gid=uv-guv;
    
    float h = max(abs(guv.x),dot(abs(guv),normalize(hr)));
    
    return vec3(h,gid);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y;

    mo(uv,vec2(.8,.6));
    moda(uv,6.);
    mo(uv,vec2(floor(dt(BPM/8.,0. )*8.))); 
    
    vec3 f = frame(uv*5.);
    f.yz += .1;
    float lf = length(f.yz);
    vec2 anim = vec2(cos(dt(1.,atan(f.z,f.y)-lf)*TAU),sin(dt(1.,atan(f.z,f.y)-lf)*TAU))*0.02;
    float ih = frame((uv+anim)*5.).x; 
    vec3 col = AAstep(0.4,f.x)*palette(lf,vec3(1.5),vec3(0.,0.63,0.37),0.7)
               + AAstep(ih,0.25)*palette(lf,vec3(1.4),vec3(0.,0.63,0.37),0.45);
    
    gl_FragColor = vec4(sqrt(col),1.0);
}